#ifndef CUFFTDX_FFT_25_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_25_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<357, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<601>;
.reg .b64 rd<2>;
add.f32 f101, %63, %103;
add.f32 f102, %50, f101;
add.f32 f103, %76, %90;
add.f32 f104, f103, f102;
add.f32 f105, %65, %105;
add.f32 f106, %51, f105;
add.f32 f107, %78, %91;
add.f32 f108, f107, f106;
fma.rn.f32 f109, f101, 0f3E9E377A, %50;
mul.f32 f110, f103, 0f3F4F1BBD;
sub.f32 f111, f109, f110;
sub.f32 f112, %65, %105;
mul.f32 f113, f112, 0f3F737871;
sub.f32 f114, %78, %91;
fma.rn.f32 f115, f114, 0f3F167918, f113;
sub.f32 f116, f111, f115;
add.f32 f117, f115, f111;
mul.f32 f118, f101, 0f3F4F1BBD;
sub.f32 f119, %50, f118;
fma.rn.f32 f120, f103, 0f3E9E377A, f119;
mul.f32 f121, f112, 0f3F167918;
mul.f32 f122, f114, 0f3F737871;
sub.f32 f123, f121, f122;
sub.f32 f124, f120, f123;
add.f32 f125, f123, f120;
fma.rn.f32 f126, f105, 0f3E9E377A, %51;
mul.f32 f127, f107, 0f3F4F1BBD;
sub.f32 f128, f126, f127;
sub.f32 f129, %63, %103;
mul.f32 f130, f129, 0f3F737871;
sub.f32 f131, %76, %90;
fma.rn.f32 f132, f131, 0f3F167918, f130;
add.f32 f133, f132, f128;
sub.f32 f134, f128, f132;
mul.f32 f135, f105, 0f3F4F1BBD;
sub.f32 f136, %51, f135;
fma.rn.f32 f137, f107, 0f3E9E377A, f136;
mul.f32 f138, f129, 0f3F167918;
mul.f32 f139, f131, 0f3F737871;
sub.f32 f140, f138, f139;
add.f32 f141, f140, f137;
sub.f32 f142, f137, f140;
add.f32 f143, %66, %106;
add.f32 f144, %52, f143;
add.f32 f145, %79, %92;
add.f32 f146, f145, f144;
add.f32 f147, %67, %107;
add.f32 f148, %54, f147;
add.f32 f149, %81, %94;
add.f32 f150, f149, f148;
fma.rn.f32 f151, f143, 0f3E9E377A, %52;
mul.f32 f152, f145, 0f3F4F1BBD;
sub.f32 f153, f151, f152;
sub.f32 f154, %67, %107;
mul.f32 f155, f154, 0f3F737871;
sub.f32 f156, %81, %94;
fma.rn.f32 f157, f156, 0f3F167918, f155;
sub.f32 f158, f153, f157;
add.f32 f159, f157, f153;
mul.f32 f160, f143, 0f3F4F1BBD;
sub.f32 f161, %52, f160;
fma.rn.f32 f162, f145, 0f3E9E377A, f161;
mul.f32 f163, f154, 0f3F167918;
mul.f32 f164, f156, 0f3F737871;
sub.f32 f165, f163, f164;
sub.f32 f166, f162, f165;
add.f32 f167, f165, f162;
fma.rn.f32 f168, f147, 0f3E9E377A, %54;
mul.f32 f169, f149, 0f3F4F1BBD;
sub.f32 f170, f168, f169;
sub.f32 f171, %66, %106;
mul.f32 f172, f171, 0f3F737871;
sub.f32 f173, %79, %92;
fma.rn.f32 f174, f173, 0f3F167918, f172;
add.f32 f175, f174, f170;
sub.f32 f176, f170, f174;
mul.f32 f177, f147, 0f3F4F1BBD;
sub.f32 f178, %54, f177;
fma.rn.f32 f179, f149, 0f3E9E377A, f178;
mul.f32 f180, f171, 0f3F167918;
mul.f32 f181, f173, 0f3F737871;
sub.f32 f182, f180, f181;
add.f32 f183, f182, f179;
sub.f32 f184, f179, f182;
add.f32 f185, %68, %108;
add.f32 f186, %55, f185;
add.f32 f187, %82, %95;
add.f32 f188, f187, f186;
add.f32 f189, %70, %110;
add.f32 f190, %57, f189;
add.f32 f191, %83, %97;
add.f32 f192, f191, f190;
fma.rn.f32 f193, f185, 0f3E9E377A, %55;
mul.f32 f194, f187, 0f3F4F1BBD;
sub.f32 f195, f193, f194;
sub.f32 f196, %70, %110;
mul.f32 f197, f196, 0f3F737871;
sub.f32 f198, %83, %97;
fma.rn.f32 f199, f198, 0f3F167918, f197;
sub.f32 f200, f195, f199;
add.f32 f201, f199, f195;
mul.f32 f202, f185, 0f3F4F1BBD;
sub.f32 f203, %55, f202;
fma.rn.f32 f204, f187, 0f3E9E377A, f203;
mul.f32 f205, f196, 0f3F167918;
mul.f32 f206, f198, 0f3F737871;
sub.f32 f207, f205, f206;
sub.f32 f208, f204, f207;
add.f32 f209, f207, f204;
fma.rn.f32 f210, f189, 0f3E9E377A, %57;
mul.f32 f211, f191, 0f3F4F1BBD;
sub.f32 f212, f210, f211;
sub.f32 f213, %68, %108;
mul.f32 f214, f213, 0f3F737871;
sub.f32 f215, %82, %95;
fma.rn.f32 f216, f215, 0f3F167918, f214;
add.f32 f217, f216, f212;
sub.f32 f218, f212, f216;
mul.f32 f219, f189, 0f3F4F1BBD;
sub.f32 f220, %57, f219;
fma.rn.f32 f221, f191, 0f3E9E377A, f220;
mul.f32 f222, f213, 0f3F167918;
mul.f32 f223, f215, 0f3F737871;
sub.f32 f224, f222, f223;
add.f32 f225, f224, f221;
sub.f32 f226, f221, f224;
add.f32 f227, %71, %111;
add.f32 f228, %58, f227;
add.f32 f229, %84, %98;
add.f32 f230, f229, f228;
add.f32 f231, %73, %113;
add.f32 f232, %59, f231;
add.f32 f233, %86, %99;
add.f32 f234, f233, f232;
fma.rn.f32 f235, f227, 0f3E9E377A, %58;
mul.f32 f236, f229, 0f3F4F1BBD;
sub.f32 f237, f235, f236;
sub.f32 f238, %73, %113;
mul.f32 f239, f238, 0f3F737871;
sub.f32 f240, %86, %99;
fma.rn.f32 f241, f240, 0f3F167918, f239;
sub.f32 f242, f237, f241;
add.f32 f243, f241, f237;
mul.f32 f244, f227, 0f3F4F1BBD;
sub.f32 f245, %58, f244;
fma.rn.f32 f246, f229, 0f3E9E377A, f245;
mul.f32 f247, f238, 0f3F167918;
mul.f32 f248, f240, 0f3F737871;
sub.f32 f249, f247, f248;
sub.f32 f250, f246, f249;
add.f32 f251, f249, f246;
fma.rn.f32 f252, f231, 0f3E9E377A, %59;
mul.f32 f253, f233, 0f3F4F1BBD;
sub.f32 f254, f252, f253;
sub.f32 f255, %71, %111;
mul.f32 f256, f255, 0f3F737871;
sub.f32 f257, %84, %98;
fma.rn.f32 f258, f257, 0f3F167918, f256;
add.f32 f259, f258, f254;
sub.f32 f260, f254, f258;
mul.f32 f261, f231, 0f3F4F1BBD;
sub.f32 f262, %59, f261;
fma.rn.f32 f263, f233, 0f3E9E377A, f262;
mul.f32 f264, f255, 0f3F167918;
mul.f32 f265, f257, 0f3F737871;
sub.f32 f266, f264, f265;
add.f32 f267, f266, f263;
sub.f32 f268, f263, f266;
add.f32 f269, %74, %114;
add.f32 f270, %60, f269;
add.f32 f271, %87, %100;
add.f32 f272, f271, f270;
add.f32 f273, %75, %115;
add.f32 f274, %62, f273;
add.f32 f275, %89, %102;
add.f32 f276, f275, f274;
fma.rn.f32 f277, f269, 0f3E9E377A, %60;
mul.f32 f278, f271, 0f3F4F1BBD;
sub.f32 f279, f277, f278;
sub.f32 f280, %75, %115;
mul.f32 f281, f280, 0f3F737871;
sub.f32 f282, %89, %102;
fma.rn.f32 f283, f282, 0f3F167918, f281;
sub.f32 f284, f279, f283;
add.f32 f285, f283, f279;
mul.f32 f286, f269, 0f3F4F1BBD;
sub.f32 f287, %60, f286;
fma.rn.f32 f288, f271, 0f3E9E377A, f287;
mul.f32 f289, f280, 0f3F167918;
mul.f32 f290, f282, 0f3F737871;
sub.f32 f291, f289, f290;
sub.f32 f292, f288, f291;
add.f32 f293, f291, f288;
fma.rn.f32 f294, f273, 0f3E9E377A, %62;
mul.f32 f295, f275, 0f3F4F1BBD;
sub.f32 f296, f294, f295;
sub.f32 f297, %74, %114;
mul.f32 f298, f297, 0f3F737871;
sub.f32 f299, %87, %100;
fma.rn.f32 f300, f299, 0f3F167918, f298;
add.f32 f301, f300, f296;
sub.f32 f302, f296, f300;
mul.f32 f303, f273, 0f3F4F1BBD;
sub.f32 f304, %62, f303;
fma.rn.f32 f305, f275, 0f3E9E377A, f304;
mul.f32 f306, f297, 0f3F167918;
mul.f32 f307, f299, 0f3F737871;
sub.f32 f308, f306, f307;
add.f32 f309, f308, f305;
sub.f32 f310, f305, f308;
mul.f32 f311, f158, 0f3F77F511;
mul.f32 f312, f175, 0f3E7EA890;
sub.f32 f313, f311, f312;
mul.f32 f314, f175, 0f3F77F511;
fma.rn.f32 f315, f158, 0f3E7EA890, f314;
mul.f32 f316, f200, 0f3F6055A2;
mul.f32 f317, f217, 0f3EF6A86B;
sub.f32 f318, f316, f317;
mul.f32 f319, f217, 0f3F6055A2;
fma.rn.f32 f320, f200, 0f3EF6A86B, f319;
mul.f32 f321, f242, 0f3F3A9DB0;
mul.f32 f322, f259, 0f3F2F3E7B;
sub.f32 f323, f321, f322;
mul.f32 f324, f259, 0f3F3A9DB0;
fma.rn.f32 f325, f242, 0f3F2F3E7B, f324;
mul.f32 f326, f284, 0f3F092BF2;
mul.f32 f327, f301, 0f3F5825E0;
sub.f32 f328, f326, f327;
mul.f32 f329, f301, 0f3F092BF2;
fma.rn.f32 f330, f284, 0f3F5825E0, f329;
mul.f32 f331, f166, 0f3F6055A2;
mul.f32 f332, f183, 0f3EF6A86B;
sub.f32 f333, f331, f332;
mul.f32 f334, f183, 0f3F6055A2;
fma.rn.f32 f335, f166, 0f3EF6A86B, f334;
mul.f32 f336, f208, 0f3F092BF2;
mul.f32 f337, f225, 0f3F5825E0;
sub.f32 f338, f336, f337;
mul.f32 f339, f225, 0f3F092BF2;
fma.rn.f32 f340, f208, 0f3F5825E0, f339;
mul.f32 f341, f250, 0f3D809851;
mul.f32 f342, f267, 0f3F7F7EAE;
sub.f32 f343, f341, f342;
mul.f32 f344, f267, 0f3D809851;
fma.rn.f32 f345, f250, 0f3F7F7EAE, f344;
mul.f32 f346, f292, 0fBED9FFBE;
mul.f32 f347, f309, 0f3F67A2BF;
sub.f32 f348, f346, f347;
mul.f32 f349, f309, 0fBED9FFBE;
fma.rn.f32 f350, f292, 0f3F67A2BF, f349;
mul.f32 f351, f167, 0f3F3A9DB0;
mul.f32 f352, f184, 0f3F2F3E7B;
sub.f32 f353, f351, f352;
mul.f32 f354, f184, 0f3F3A9DB0;
fma.rn.f32 f355, f167, 0f3F2F3E7B, f354;
mul.f32 f356, f209, 0f3D809851;
mul.f32 f357, f226, 0f3F7F7EAE;
sub.f32 f358, f356, f357;
mul.f32 f359, f226, 0f3D809851;
fma.rn.f32 f360, f209, 0f3F7F7EAE, f359;
mul.f32 f361, f251, 0fBF232E38;
mul.f32 f362, f268, 0f3F45405B;
sub.f32 f363, f361, f362;
mul.f32 f364, f268, 0fBF232E38;
fma.rn.f32 f365, f251, 0f3F45405B, f364;
mul.f32 f366, f293, 0fBF7DFB3B;
mul.f32 f367, f310, 0f3E00575B;
sub.f32 f368, f366, f367;
mul.f32 f369, f310, 0fBF7DFB3B;
fma.rn.f32 f370, f293, 0f3E00575B, f369;
mul.f32 f371, f159, 0f3F092BF2;
mul.f32 f372, f176, 0f3F5825E0;
sub.f32 f373, f371, f372;
mul.f32 f374, f176, 0f3F092BF2;
fma.rn.f32 f375, f159, 0f3F5825E0, f374;
mul.f32 f376, f201, 0fBED9FFBE;
mul.f32 f377, f218, 0f3F67A2BF;
sub.f32 f378, f376, f377;
mul.f32 f379, f218, 0fBED9FFBE;
fma.rn.f32 f380, f201, 0f3F67A2BF, f379;
mul.f32 f381, f243, 0fBF7DFB3B;
mul.f32 f382, f260, 0f3E00575B;
sub.f32 f383, f381, f382;
mul.f32 f384, f260, 0fBF7DFB3B;
fma.rn.f32 f385, f243, 0f3E00575B, f384;
mul.f32 f386, f285, 0fBF232E38;
mul.f32 f387, f302, 0fBF45405B;
sub.f32 f388, f386, f387;
mul.f32 f389, f302, 0fBF232E38;
fma.rn.f32 f390, f285, 0fBF45405B, f389;
add.f32 f391, f146, f272;
add.f32 f392, f104, f391;
add.f32 f393, f188, f230;
add.f32 f394, f150, f276;
add.f32 f395, f108, f394;
add.f32 f396, f192, f234;
fma.rn.f32 f397, f391, 0f3E9E377A, f104;
mul.f32 f398, f393, 0f3F4F1BBD;
sub.f32 f399, f397, f398;
sub.f32 f400, f150, f276;
mul.f32 f401, f400, 0f3F737871;
sub.f32 f402, f192, f234;
fma.rn.f32 f403, f402, 0f3F167918, f401;
mul.f32 f404, f391, 0f3F4F1BBD;
sub.f32 f405, f104, f404;
fma.rn.f32 f406, f393, 0f3E9E377A, f405;
mul.f32 f407, f400, 0f3F167918;
mul.f32 f408, f402, 0f3F737871;
sub.f32 f409, f407, f408;
fma.rn.f32 f410, f394, 0f3E9E377A, f108;
mul.f32 f411, f396, 0f3F4F1BBD;
sub.f32 f412, f410, f411;
sub.f32 f413, f146, f272;
mul.f32 f414, f413, 0f3F737871;
sub.f32 f415, f188, f230;
fma.rn.f32 f416, f415, 0f3F167918, f414;
mul.f32 f417, f394, 0f3F4F1BBD;
sub.f32 f418, f108, f417;
fma.rn.f32 f419, f396, 0f3E9E377A, f418;
mul.f32 f420, f413, 0f3F167918;
mul.f32 f421, f415, 0f3F737871;
sub.f32 f422, f420, f421;
add.f32 f423, f313, f328;
add.f32 f424, f116, f423;
add.f32 f425, f318, f323;
add.f32 f426, f315, f330;
add.f32 f427, f133, f426;
add.f32 f428, f320, f325;
fma.rn.f32 f429, f423, 0f3E9E377A, f116;
mul.f32 f430, f425, 0f3F4F1BBD;
sub.f32 f431, f429, f430;
sub.f32 f432, f315, f330;
mul.f32 f433, f432, 0f3F737871;
sub.f32 f434, f320, f325;
fma.rn.f32 f435, f434, 0f3F167918, f433;
mul.f32 f436, f423, 0f3F4F1BBD;
sub.f32 f437, f116, f436;
fma.rn.f32 f438, f425, 0f3E9E377A, f437;
mul.f32 f439, f432, 0f3F167918;
mul.f32 f440, f434, 0f3F737871;
sub.f32 f441, f439, f440;
fma.rn.f32 f442, f426, 0f3E9E377A, f133;
mul.f32 f443, f428, 0f3F4F1BBD;
sub.f32 f444, f442, f443;
sub.f32 f445, f313, f328;
mul.f32 f446, f445, 0f3F737871;
sub.f32 f447, f318, f323;
fma.rn.f32 f448, f447, 0f3F167918, f446;
mul.f32 f449, f426, 0f3F4F1BBD;
sub.f32 f450, f133, f449;
fma.rn.f32 f451, f428, 0f3E9E377A, f450;
mul.f32 f452, f445, 0f3F167918;
mul.f32 f453, f447, 0f3F737871;
sub.f32 f454, f452, f453;
add.f32 f455, f333, f348;
add.f32 f456, f124, f455;
add.f32 f457, f338, f343;
add.f32 f458, f335, f350;
add.f32 f459, f141, f458;
add.f32 f460, f340, f345;
fma.rn.f32 f461, f455, 0f3E9E377A, f124;
mul.f32 f462, f457, 0f3F4F1BBD;
sub.f32 f463, f461, f462;
sub.f32 f464, f335, f350;
mul.f32 f465, f464, 0f3F737871;
sub.f32 f466, f340, f345;
fma.rn.f32 f467, f466, 0f3F167918, f465;
mul.f32 f468, f455, 0f3F4F1BBD;
sub.f32 f469, f124, f468;
fma.rn.f32 f470, f457, 0f3E9E377A, f469;
mul.f32 f471, f464, 0f3F167918;
mul.f32 f472, f466, 0f3F737871;
sub.f32 f473, f471, f472;
fma.rn.f32 f474, f458, 0f3E9E377A, f141;
mul.f32 f475, f460, 0f3F4F1BBD;
sub.f32 f476, f474, f475;
sub.f32 f477, f333, f348;
mul.f32 f478, f477, 0f3F737871;
sub.f32 f479, f338, f343;
fma.rn.f32 f480, f479, 0f3F167918, f478;
mul.f32 f481, f458, 0f3F4F1BBD;
sub.f32 f482, f141, f481;
fma.rn.f32 f483, f460, 0f3E9E377A, f482;
mul.f32 f484, f477, 0f3F167918;
mul.f32 f485, f479, 0f3F737871;
sub.f32 f486, f484, f485;
add.f32 f487, f353, f368;
add.f32 f488, f125, f487;
add.f32 f489, f358, f363;
add.f32 f490, f355, f370;
add.f32 f491, f142, f490;
add.f32 f492, f360, f365;
fma.rn.f32 f493, f487, 0f3E9E377A, f125;
mul.f32 f494, f489, 0f3F4F1BBD;
sub.f32 f495, f493, f494;
sub.f32 f496, f355, f370;
mul.f32 f497, f496, 0f3F737871;
sub.f32 f498, f360, f365;
fma.rn.f32 f499, f498, 0f3F167918, f497;
mul.f32 f500, f487, 0f3F4F1BBD;
sub.f32 f501, f125, f500;
fma.rn.f32 f502, f489, 0f3E9E377A, f501;
mul.f32 f503, f496, 0f3F167918;
mul.f32 f504, f498, 0f3F737871;
sub.f32 f505, f503, f504;
fma.rn.f32 f506, f490, 0f3E9E377A, f142;
mul.f32 f507, f492, 0f3F4F1BBD;
sub.f32 f508, f506, f507;
sub.f32 f509, f353, f368;
mul.f32 f510, f509, 0f3F737871;
sub.f32 f511, f358, f363;
fma.rn.f32 f512, f511, 0f3F167918, f510;
mul.f32 f513, f490, 0f3F4F1BBD;
sub.f32 f514, f142, f513;
fma.rn.f32 f515, f492, 0f3E9E377A, f514;
mul.f32 f516, f509, 0f3F167918;
mul.f32 f517, f511, 0f3F737871;
sub.f32 f518, f516, f517;
add.f32 f519, f373, f388;
add.f32 f520, f117, f519;
add.f32 f521, f378, f383;
add.f32 f522, f375, f390;
add.f32 f523, f134, f522;
add.f32 f524, f380, f385;
fma.rn.f32 f525, f519, 0f3E9E377A, f117;
mul.f32 f526, f521, 0f3F4F1BBD;
sub.f32 f527, f525, f526;
sub.f32 f528, f375, f390;
mul.f32 f529, f528, 0f3F737871;
sub.f32 f530, f380, f385;
fma.rn.f32 f531, f530, 0f3F167918, f529;
mul.f32 f532, f519, 0f3F4F1BBD;
sub.f32 f533, f117, f532;
fma.rn.f32 f534, f521, 0f3E9E377A, f533;
mul.f32 f535, f528, 0f3F167918;
mul.f32 f536, f530, 0f3F737871;
sub.f32 f537, f535, f536;
fma.rn.f32 f538, f522, 0f3E9E377A, f134;
mul.f32 f539, f524, 0f3F4F1BBD;
sub.f32 f540, f538, f539;
sub.f32 f541, f373, f388;
mul.f32 f542, f541, 0f3F737871;
sub.f32 f543, f378, f383;
fma.rn.f32 f544, f543, 0f3F167918, f542;
mul.f32 f545, f522, 0f3F4F1BBD;
sub.f32 f546, f134, f545;
fma.rn.f32 f547, f524, 0f3E9E377A, f546;
mul.f32 f548, f541, 0f3F167918;
mul.f32 f549, f543, 0f3F737871;
sub.f32 f550, f548, f549;
add.f32 %1, f396, f395;
add.f32 %0, f393, f392;
add.f32 %3, f428, f427;
add.f32 %2, f425, f424;
add.f32 %5, f460, f459;
add.f32 %4, f457, f456;
add.f32 %7, f492, f491;
add.f32 %6, f489, f488;
add.f32 %9, f524, f523;
add.f32 %8, f521, f520;
add.f32 %11, f416, f412;
sub.f32 %10, f399, f403;
add.f32 %13, f448, f444;
sub.f32 %12, f431, f435;
add.f32 %15, f480, f476;
sub.f32 %14, f463, f467;
add.f32 %17, f512, f508;
sub.f32 %16, f495, f499;
add.f32 %19, f544, f540;
sub.f32 %18, f527, f531;
add.f32 %21, f422, f419;
sub.f32 %20, f406, f409;
add.f32 %23, f454, f451;
sub.f32 %22, f438, f441;
add.f32 %25, f486, f483;
sub.f32 %24, f470, f473;
add.f32 %27, f518, f515;
sub.f32 %26, f502, f505;
add.f32 %29, f550, f547;
sub.f32 %28, f534, f537;
sub.f32 %31, f419, f422;
add.f32 %30, f409, f406;
sub.f32 %33, f451, f454;
add.f32 %32, f441, f438;
sub.f32 %35, f483, f486;
add.f32 %34, f473, f470;
sub.f32 %37, f515, f518;
add.f32 %36, f505, f502;
sub.f32 %39, f547, f550;
add.f32 %38, f537, f534;
sub.f32 %41, f412, f416;
add.f32 %40, f403, f399;
sub.f32 %43, f444, f448;
add.f32 %42, f435, f431;
sub.f32 %45, f476, f480;
add.f32 %44, f467, f463;
sub.f32 %47, f508, f512;
add.f32 %46, f499, f495;
sub.f32 %49, f540, f544;
add.f32 %48, f531, f527;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y): "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<358, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<164>;
.reg .b32 r<12>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 200, r2;
mov.u32 r4, %tid.x;
add.f32 f21, %14, %22;
add.f32 f22, %12, f21;
add.f32 f23, %17, %20;
add.f32 f24, %16, %23;
add.f32 f25, %13, f24;
add.f32 f26, %19, %21;
fma.rn.f32 f27, f21, 0f3E9E377A, %12;
mul.f32 f28, f23, 0f3F4F1BBD;
sub.f32 f29, f27, f28;
sub.f32 f30, %16, %23;
mul.f32 f31, f30, 0f3F737871;
sub.f32 f32, %19, %21;
fma.rn.f32 f33, f32, 0f3F167918, f31;
sub.f32 f34, f29, f33;
add.f32 f35, f33, f29;
mul.f32 f36, f21, 0f3F4F1BBD;
sub.f32 f37, %12, f36;
fma.rn.f32 f38, f23, 0f3E9E377A, f37;
mul.f32 f39, f30, 0f3F167918;
mul.f32 f40, f32, 0f3F737871;
sub.f32 f41, f39, f40;
sub.f32 f42, f38, f41;
add.f32 f43, f41, f38;
fma.rn.f32 f44, f24, 0f3E9E377A, %13;
mul.f32 f45, f26, 0f3F4F1BBD;
sub.f32 f46, f44, f45;
sub.f32 f47, %14, %22;
mul.f32 f48, f47, 0f3F737871;
sub.f32 f49, %17, %20;
fma.rn.f32 f50, f49, 0f3F167918, f48;
add.f32 f51, f50, f46;
sub.f32 f52, f46, f50;
mul.f32 f53, f24, 0f3F4F1BBD;
sub.f32 f54, %13, f53;
fma.rn.f32 f55, f26, 0f3E9E377A, f54;
mul.f32 f56, f47, 0f3F167918;
mul.f32 f57, f49, 0f3F737871;
sub.f32 f58, f56, f57;
add.f32 f59, f58, f55;
sub.f32 f60, f55, f58;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 5;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 200, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f61, f62}, [rd6];
mul.f32 f65, f51, f62;
mul.f32 f66, f34, f62;
mul.f32 f67, f61, f51;
mul.f32 f68, f61, f61;
mul.f32 f69, f62, f62;
sub.f32 f70, f68, f69;
mul.f32 f71, f62, f61;
fma.rn.f32 f72, f62, f61, f71;
mul.f32 f73, f59, f72;
mul.f32 f74, f42, f72;
mul.f32 f75, f70, f59;
mul.f32 f76, f61, f70;
mul.f32 f77, f62, f72;
sub.f32 f78, f76, f77;
mul.f32 f79, f61, f72;
fma.rn.f32 f80, f62, f70, f79;
mul.f32 f81, f60, f80;
mul.f32 f82, f43, f80;
mul.f32 f83, f78, f60;
mul.f32 f84, f61, f78;
mul.f32 f85, f62, f80;
sub.f32 f86, f84, f85;
mul.f32 f87, f61, f80;
fma.rn.f32 f88, f62, f78, f87;
mul.f32 f89, f52, f88;
mul.f32 f90, f35, f88;
mul.f32 f91, f86, f52;
barrier.sync 0;
mad.lo.s32 r9, r7, 40, r8;
add.f32 f92, f26, f25;
add.f32 f93, f23, f22;
st.shared.v2.f32 [r9], {f93, f92};
fma.rn.f32 f94, f61, f34, f65;
sub.f32 f95, f67, f66;
st.shared.v2.f32 [r9+8], {f94, f95};
fma.rn.f32 f96, f70, f42, f73;
sub.f32 f97, f75, f74;
st.shared.v2.f32 [r9+16], {f96, f97};
sub.f32 f98, f83, f82;
fma.rn.f32 f99, f78, f43, f81;
st.shared.v2.f32 [r9+24], {f99, f98};
fma.rn.f32 f100, f86, f35, f89;
sub.f32 f101, f91, f90;
st.shared.v2.f32 [r9+32], {f100, f101};
barrier.sync 0;
shl.b32 r10, r7, 5;
sub.s32 r11, r9, r10;
ld.shared.v2.f32 {f102, f103}, [r11];
ld.shared.v2.f32 {f106, f107}, [r11+40];
ld.shared.v2.f32 {f110, f111}, [r11+80];
ld.shared.v2.f32 {f114, f115}, [r11+120];
ld.shared.v2.f32 {f118, f119}, [r11+160];
add.f32 f122, f106, f118;
add.f32 f123, f102, f122;
add.f32 f124, f110, f114;
add.f32 f125, f107, f119;
add.f32 f126, f103, f125;
add.f32 f127, f111, f115;
fma.rn.f32 f128, f122, 0f3E9E377A, f102;
mul.f32 f129, f124, 0f3F4F1BBD;
sub.f32 f130, f128, f129;
sub.f32 f131, f107, f119;
mul.f32 f132, f131, 0f3F737871;
sub.f32 f133, f111, f115;
fma.rn.f32 f134, f133, 0f3F167918, f132;
mul.f32 f135, f122, 0f3F4F1BBD;
sub.f32 f136, f102, f135;
fma.rn.f32 f137, f124, 0f3E9E377A, f136;
mul.f32 f138, f131, 0f3F167918;
mul.f32 f139, f133, 0f3F737871;
sub.f32 f140, f138, f139;
fma.rn.f32 f141, f125, 0f3E9E377A, f103;
mul.f32 f142, f127, 0f3F4F1BBD;
sub.f32 f143, f141, f142;
sub.f32 f144, f106, f118;
mul.f32 f145, f144, 0f3F737871;
sub.f32 f146, f110, f114;
fma.rn.f32 f147, f146, 0f3F167918, f145;
mul.f32 f148, f125, 0f3F4F1BBD;
sub.f32 f149, f103, f148;
fma.rn.f32 f150, f127, 0f3E9E377A, f149;
mul.f32 f151, f144, 0f3F167918;
mul.f32 f152, f146, 0f3F737871;
sub.f32 f153, f151, f152;
add.f32 %1, f127, f126;
add.f32 %0, f124, f123;
add.f32 %3, f147, f143;
sub.f32 %2, f130, f134;
add.f32 %5, f153, f150;
sub.f32 %4, f137, f140;
sub.f32 %7, f150, f153;
add.f32 %6, f140, f137;
sub.f32 %9, f143, f147;
add.f32 %8, f134, f130;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y): "r"(smem), "l"(lut_sp_5_25), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<359, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<154>;
.reg .b32 r<12>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 100, r2;
mov.u32 r4, %tid.x;
add.f32 f21, %14, %22;
add.f32 f22, %12, f21;
add.f32 f23, %17, %20;
add.f32 f24, f23, f22;
add.f32 f25, %16, %23;
add.f32 f26, %13, f25;
add.f32 f27, %19, %21;
add.f32 f28, f27, f26;
fma.rn.f32 f29, f21, 0f3E9E377A, %12;
mul.f32 f30, f23, 0f3F4F1BBD;
sub.f32 f31, f29, f30;
sub.f32 f32, %16, %23;
mul.f32 f33, f32, 0f3F737871;
sub.f32 f34, %19, %21;
fma.rn.f32 f35, f34, 0f3F167918, f33;
sub.f32 f36, f31, f35;
add.f32 f37, f35, f31;
mul.f32 f38, f21, 0f3F4F1BBD;
sub.f32 f39, %12, f38;
fma.rn.f32 f40, f23, 0f3E9E377A, f39;
mul.f32 f41, f32, 0f3F167918;
mul.f32 f42, f34, 0f3F737871;
sub.f32 f43, f41, f42;
sub.f32 f44, f40, f43;
add.f32 f45, f43, f40;
fma.rn.f32 f46, f25, 0f3E9E377A, %13;
mul.f32 f47, f27, 0f3F4F1BBD;
sub.f32 f48, f46, f47;
sub.f32 f49, %14, %22;
mul.f32 f50, f49, 0f3F737871;
sub.f32 f51, %17, %20;
fma.rn.f32 f52, f51, 0f3F167918, f50;
add.f32 f53, f52, f48;
sub.f32 f54, f48, f52;
mul.f32 f55, f25, 0f3F4F1BBD;
sub.f32 f56, %13, f55;
fma.rn.f32 f57, f27, 0f3E9E377A, f56;
mul.f32 f58, f49, 0f3F167918;
mul.f32 f59, f51, 0f3F737871;
sub.f32 f60, f58, f59;
add.f32 f61, f60, f57;
sub.f32 f62, f57, f60;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 5;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f63, f64}, [rd6];
mul.f32 f67, f53, f64;
fma.rn.f32 f68, f63, f36, f67;
mul.f32 f69, f36, f64;
mul.f32 f70, f63, f53;
sub.f32 f71, f70, f69;
mul.f32 f72, f63, f63;
mul.f32 f73, f64, f64;
sub.f32 f74, f72, f73;
mul.f32 f75, f64, f63;
fma.rn.f32 f76, f64, f63, f75;
mul.f32 f77, f61, f76;
fma.rn.f32 f78, f74, f44, f77;
mul.f32 f79, f44, f76;
mul.f32 f80, f74, f61;
sub.f32 f81, f80, f79;
mul.f32 f82, f63, f74;
mul.f32 f83, f64, f76;
sub.f32 f84, f82, f83;
mul.f32 f85, f63, f76;
fma.rn.f32 f86, f64, f74, f85;
mul.f32 f87, f62, f86;
fma.rn.f32 f88, f84, f45, f87;
mul.f32 f89, f45, f86;
mul.f32 f90, f84, f62;
sub.f32 f91, f90, f89;
mul.f32 f92, f63, f84;
mul.f32 f93, f64, f86;
sub.f32 f94, f92, f93;
mul.f32 f95, f63, f86;
fma.rn.f32 f96, f64, f84, f95;
mul.f32 f97, f54, f96;
fma.rn.f32 f98, f94, f37, f97;
mul.f32 f99, f37, f96;
mul.f32 f100, f94, f54;
sub.f32 f101, f100, f99;
mad.lo.s32 r8, r5, 100, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 20, r8;
st.shared.f32 [r9], f24;
st.shared.f32 [r9+4], f68;
st.shared.f32 [r9+8], f78;
st.shared.f32 [r9+12], f88;
st.shared.f32 [r9+16], f98;
barrier.sync 0;
shl.b32 r10, r7, 4;
sub.s32 r11, r9, r10;
ld.shared.f32 f102, [r11];
ld.shared.f32 f103, [r11+20];
ld.shared.f32 f104, [r11+40];
ld.shared.f32 f105, [r11+60];
ld.shared.f32 f106, [r11+80];
barrier.sync 0;
st.shared.f32 [r9], f28;
st.shared.f32 [r9+4], f71;
st.shared.f32 [r9+8], f81;
st.shared.f32 [r9+12], f91;
st.shared.f32 [r9+16], f101;
barrier.sync 0;
ld.shared.f32 f107, [r11];
ld.shared.f32 f108, [r11+20];
ld.shared.f32 f109, [r11+40];
ld.shared.f32 f110, [r11+60];
ld.shared.f32 f111, [r11+80];
add.f32 f112, f103, f106;
add.f32 f113, f102, f112;
add.f32 f114, f104, f105;
add.f32 f115, f108, f111;
add.f32 f116, f107, f115;
add.f32 f117, f109, f110;
fma.rn.f32 f118, f112, 0f3E9E377A, f102;
mul.f32 f119, f114, 0f3F4F1BBD;
sub.f32 f120, f118, f119;
sub.f32 f121, f108, f111;
mul.f32 f122, f121, 0f3F737871;
sub.f32 f123, f109, f110;
fma.rn.f32 f124, f123, 0f3F167918, f122;
mul.f32 f125, f112, 0f3F4F1BBD;
sub.f32 f126, f102, f125;
fma.rn.f32 f127, f114, 0f3E9E377A, f126;
mul.f32 f128, f121, 0f3F167918;
mul.f32 f129, f123, 0f3F737871;
sub.f32 f130, f128, f129;
fma.rn.f32 f131, f115, 0f3E9E377A, f107;
mul.f32 f132, f117, 0f3F4F1BBD;
sub.f32 f133, f131, f132;
sub.f32 f134, f103, f106;
mul.f32 f135, f134, 0f3F737871;
sub.f32 f136, f104, f105;
fma.rn.f32 f137, f136, 0f3F167918, f135;
mul.f32 f138, f115, 0f3F4F1BBD;
sub.f32 f139, f107, f138;
fma.rn.f32 f140, f117, 0f3E9E377A, f139;
mul.f32 f141, f134, 0f3F167918;
mul.f32 f142, f136, 0f3F737871;
sub.f32 f143, f141, f142;
add.f32 %0, f114, f113;
add.f32 %1, f117, f116;
add.f32 %3, f137, f133;
sub.f32 %2, f120, f124;
sub.f32 %4, f127, f130;
add.f32 %5, f143, f140;
add.f32 %6, f130, f127;
sub.f32 %7, f140, f143;
sub.f32 %9, f133, f137;
add.f32 %8, f124, f120;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y): "r"(smem), "l"(lut_sp_5_25), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y));
};


#endif
